@extends('layouts.app')
@section('page-title')
    {{ __('Property Edit') }}
@endsection
@push('script-page')
    <script src="{{ asset('assets/js/vendors/dropzone/dropzone.js') }}"></script>
    <script>
        var dropzone = new Dropzone('#demo-upload', {
            previewTemplate: document.querySelector('.preview-dropzon').innerHTML,
            parallelUploads: 10,
            thumbnailHeight: 120,
            thumbnailWidth: 120,
            maxFilesize: 10,
            filesizeBase: 1000,
            autoProcessQueue: false,
            thumbnail: function(file, dataUrl) {
                if (file.previewElement) {
                    file.previewElement.classList.remove("dz-file-preview");
                    var images = file.previewElement.querySelectorAll("[data-dz-thumbnail]");
                    for (var i = 0; i < images.length; i++) {
                        var thumbnailElement = images[i];
                        thumbnailElement.alt = file.name;
                        thumbnailElement.src = dataUrl;
                    }
                    setTimeout(function() {
                        file.previewElement.classList.add("dz-image-preview");
                    }, 1);
                }
            }

        });
        $('#property-update').on('click', function() {
            "use strict";
            $('#property-update').attr('disabled', true);
            var fd = new FormData();
            var file = document.getElementById('thumbnail').files[0];

            var files = $('#demo-upload').get(0).dropzone.getAcceptedFiles();
            $.each(files, function(key, file) {
                fd.append('property_images[' + key + ']', $('#demo-upload')[0].dropzone
                    .getAcceptedFiles()[key]); // attach dropzone image element
            });
            if (file == undefined) {
                fd.append('thumbnail', '');
            } else {
                fd.append('thumbnail', file);
            }

            var other_data = $('#property_form').serializeArray();
            $.each(other_data, function(key, input) {
                fd.append(input.name, input.value);
            });
            fd.append('description', $('.ck-content').html());
            $.ajax({
                url: "{{ route('property.update', $property->id) }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: fd,
                contentType: false,
                processData: false,
                type: 'POST',
                success: function(data) {
                    if (data.status == "success") {
                        $('#property-update').attr('disabled', true);
                        toastrs('success', data.msg, 'success');
                        var url = '{{ route('property.show', ':id') }}';
                        url = url.replace(':id', data.id);
                        setTimeout(() => {
                            window.location.href = url;
                        }, "1000");

                    } else {
                        toastrs('Error', data.msg, 'error');
                        $('#property-update').attr('disabled', false);
                    }
                },
                error: function(data) {
                    $('#property-update').attr('disabled', false);
                    if (data.error) {
                        toastrs('Error', data.error, 'error');
                    } else {
                        toastrs('Error', data, 'error');
                    }
                },
            });
        });
    </script>
@endpush
@section('breadcrumb')
    <ul class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('property.index') }}">{{ __('Property') }}</a>
        </li>
        <li class="breadcrumb-item active">
            <a href="#">{{ __('Edit') }}</a>
        </li>
    </ul>
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">

            {{ Form::model($property, ['route' => ['property.update', $property->id], 'method' => 'PUT', 'enctype' => 'multipart/form-data', 'id' => 'property_form']) }}
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="info-group">
                                <div class="form-group ">
                                    {{ Form::label('type', __('Type'), ['class' => 'form-label']) }}
                                    {{ Form::select('type', $types, null, ['class' => 'form-control hidesearch']) }}
                                </div>
                                <div class="form-group">
                                    {{ Form::label('name', __('Name'), ['class' => 'form-label']) }}
                                    {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('Enter Property Name')]) }}
                                </div>
                                <div class="form-group ">
                                    {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
                                    {{ Form::textarea('description', null, ['class' => 'form-control', 'id' => 'classic-editor','rows' => 8, 'placeholder' => __('Enter Property Description')]) }}
                                </div>
                                <div class="form-group">
                                    {{ Form::label('thumbnail', __('Thumbnail Image'), ['class' => 'form-label']) }}
                                    {{ Form::file('thumbnail', ['class' => 'form-control']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="info-group">
                                <div class="form-group">
                                    {{ Form::label('country', __('Country'), ['class' => 'form-label']) }}
                                    {{ Form::text('country', null, ['class' => 'form-control', 'placeholder' => __('Enter Property Country')]) }}
                                </div>
                                <div class="form-group">
                                    {{ Form::label('state', __('State'), ['class' => 'form-label']) }}
                                    {{ Form::text('state', null, ['class' => 'form-control', 'placeholder' => __('Enter Property State')]) }}
                                </div>
                                <div class="form-group">
                                    {{ Form::label('city', __('City'), ['class' => 'form-label']) }}
                                    {{ Form::text('city', null, ['class' => 'form-control', 'placeholder' => __('Enter Property City')]) }}
                                </div>
                                <div class="form-group">
                                    {{ Form::label('zip_code', __('Zip Code'), ['class' => 'form-label']) }}
                                    {{ Form::text('zip_code', null, ['class' => 'form-control', 'placeholder' => __('Enter Property Zip Code')]) }}
                                </div>
                                <div class="form-group ">
                                    {{ Form::label('address', __('Address'), ['class' => 'form-label']) }}
                                    {{ Form::textarea('address', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter Property Address')]) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            {{ Form::label('demo-upload', __('Property Images'), ['class' => 'form-label']) }}
                        </div>
                        <div class="card-body">
                            <div class="dropzone needsclick" id='demo-upload' action="#">
                                <div class="dz-message needsclick">
                                    <div class="upload-icon"><i class="fa fa-cloud-upload"></i></div>
                                    <h3>{{ __('Drop files here or click to upload.') }}</h3>
                                </div>
                            </div>
                            <div class="preview-dropzon" style="display: none;">
                                <div class="dz-preview dz-file-preview">
                                    <div class="dz-image"><img data-dz-thumbnail="" src="" alt=""></div>
                                    <div class="dz-details">
                                        <div class="dz-size"><span data-dz-size=""></span></div>
                                        <div class="dz-filename"><span data-dz-name=""></span></div>
                                    </div>
                                    <div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress=""> </span>
                                    </div>
                                    <div class="dz-success-mark"><i class="fa fa-check" aria-hidden="true"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            {{ Form::label('amenities[]', __('Amenities'), ['class' => 'form-label']) }}
                        </div>
                        <div class="card-body">
                            <div class="row">

                                @foreach ($amenities as $amenity)
                                    <div class="col-md-6 col-xl-4 mb-3">
                                        <div class="border rounded shadow-sm p-3 h-100 d-flex align-items-start gap-3">
                                            <input type="checkbox" name="amenities[]" value="{{ $amenity->id }}"
                                                id="amenity_{{ $amenity->id }}" class="form-check-input mt-1"
                                                {{ in_array($amenity->id, $selectedAmenities) ? 'checked' : '' }}>

                                            @if ($amenity->image)
                                                <img src="{{ fetch_file('upload/amenity/' . $amenity->image) }}"
                                                    alt="{{ $amenity->name }}"
                                                    style="width: 50px; height: 50px; object-fit: cover;"
                                                    class="rounded shadow-sm">
                                            @else
                                                <i class="ti ti-building text-muted fs-3 mt-1"></i>
                                            @endif
                                            <label for="amenity_{{ $amenity->id }}" class="form-check-label">
                                                <strong>{{ $amenity->name }}</strong><br>
                                                <small class="text-muted">{{ $amenity->description }}</small>
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            {{ Form::label('advantages[]', __('Advantages'), ['class' => 'form-label']) }}
                        </div>
                        <div class="card-body">
                            <div class="row">

                                @foreach ($advantages as $advantage)
                                    <div class="col-md-6 col-xl-4 mb-3">
                                        <div class="border rounded shadow-sm p-3 h-100 d-flex align-items-start gap-3">
                                            <input type="checkbox" name="advantages[]" value="{{ $advantage->id }}"
                                                id="advantage_{{ $advantage->id }}" class="form-check-input mt-1"
                                                {{ in_array($advantage->id, $selectedAdvantages) ? 'checked' : '' }}>


                                            <label for="advantage_{{ $advantage->id }}" class="form-check-label">
                                                <strong>{{ $advantage->name }}</strong><br>
                                                <small class="text-muted">{{ $advantage->description }}</small>
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 mb-4">
                    <div class="group-button text-end">
                        {{ Form::submit(__('Update'), ['class' => 'btn btn-secondary btn-rounded', 'id' => 'property-update']) }}
                    </div>
                </div>
            </div>

            {{ Form::close() }}
        </div>
    </div>
@endsection
